<div class="edgtf-single-image-holder <?php echo esc_attr($holder_classes); ?>">
    <div class="edgtf-si-inner" <?php echo haar_edge_get_inline_style($holder_styles); ?>>
        <?php if ($enable_tilt_effect == 'yes') : ?>
            <div class="edgtf-tilt-item-holder">
                <img itemprop="image" class="edgtf-pl-tilt-image edgtf-tilt-item" src="<?php echo esc_url($image['url']); ?>" alt="<?php echo esc_attr(get_the_title( $image )); ?>"  
                data-tilt-options= '{"extraImgs" : 1, "extraImgsScaleGrade": 0.1, "opacity" : 0.9, "customImgsOpacity" : [0.1, 0.9], "bgfixed" : false, "resetOnLeave" : false, "movement": { "perspective" : 1000, "translateX" : -10, "translateY" : -0, "translateZ" : 10, "rotateX" : 2, "rotateY" : 10 }}'/>
            </div>
            <?php  if (!empty($tilt_image_bg)) : ?>
                <div class="edgtf-tilt-image-bg" style="background-image:url('<?php echo wp_get_attachment_url($tilt_image_bg); ?>')"></div>
            <?php endif; ?>
        <?php endif; ?>

        <?php if ($image_behavior === 'lightbox') { ?>
            <a itemprop="image" href="<?php echo esc_url($image['url']); ?>" data-rel="prettyPhoto[si_pretty_photo]" title="<?php echo esc_attr($image['alt']); ?>">
        <?php } else if ($image_behavior === 'custom-link' && !empty($custom_link)) { ?>
	            <a class="edgtf-tilt-link" itemprop="url" href="<?php echo esc_url($custom_link); ?>" target="<?php echo esc_attr($custom_link_target); ?>">
        <?php } ?>
            <?php if(is_array($image_size) && count($image_size)) : ?>
                <?php echo haar_edge_generate_thumbnail($image['image_id'], null, $image_size[0], $image_size[1]); ?>
            <?php else: ?>
                <?php echo wp_get_attachment_image($image['image_id'], $image_size); ?>
            <?php endif; ?>
        <?php if ($image_behavior === 'lightbox' || $image_behavior === 'custom-link') { ?>
            </a>
        <?php } ?>
    </div>
</div>